; Script file for the JAWS for Windows application
; Copyright 1998, 1999  by Henter-Joyce, Inc.
; 5/7/98, A.Gonz.
;upsated and modified 03/29/99 by j.c

Include "jfw.jsh"
Include "jfw.jsm"
Include "hjconst.jsh"
Include "hjglobal.jsh"

Script ScriptFileName ()
ScriptAndAppNames (msg0)
EndScript

Script ScreenSensitiveHelp ()
var
	handle hwnd,
	string theClass
if (GlobalMenuMode == 1) then
	ScreenSensitiveHelpForKnownClasses()  ;known types
	return
EndIf
let hwnd = GetCurrentWindow ()
let theClass = GetWindowClass (hwnd)
if ((theClass == wc_JAWS) ||
	((theClass == wc_EmptySpace) && (GetWindowClass (GetParent (hwnd)) == wc_JAWS))) then
	Say(msg1, ot_message);"This is the JAWS application window. "
	Say(msg2 + ;"To toggle the keyboard help on or off press "
	GetScriptKeyName ("KeyBoardHelp") + ". ", ot_help)
	Say(msg3, ot_help);"Use Alt to activate the menu bar"
	return
EndIf
if ((StringContains (GetWindowName (GetRealWindow (GetFocus ())), wn_VOICE_OPTIONS)) ||
    (StringContains (GetWindowName (GetRealWindow (GetFocus ())), wn_VOICE_SETTINGS))) then
	if (GetControlID (GetFocus ()) == id_VOLUME) then
		Say(msg4, ot_help) ;"to change this setting in the system volume control"
		if (GetVerbosity ()==BEGINNER) then
			Say(msg5, ot_help) ;"press control+escape to open the start menu"
			Say(msg6, ot_help) ;"press p to open the programs folder"
			Say(msg7, ot_help) ;"press a to open the accessories folder"
			Say(msg8, ot_help) ;"press m to open the multimedia folder"
			Say(msg9, ot_help) ;"press v to open the volume dialog"
			Say(msg10, ot_help) ;"tab one time to get to the volume control"
			Say(msg11, ot_help);use the arrow keys to change the volume setting"
			Say(msg12, ot_help) ;"press alt + f4 to save the setting and close the dialog"
		else
			Say(msg13, ot_help) ;"go to start menu programs accessories multimedia volume control"
			Say(msg14, ot_help) ;"tab one time to get the volume control"
		endif
		return
	endif
endif
PerformScript ScreenSensitiveHelp()
EndScript

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
let RealWindow = GetRealWindow (FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
if (GlobalPrevApp != AppWindow
	&& AppWindow != FocusWindow) then 
	; we've switched to a different app main window, 
	; and it does not have the focus, so announce it
	SayWindowTypeAndText (AppWindow)
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
	|| (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If (((RealWindow != AppWindow) || (GlobalPrevApp == AppWindow))
		&& (RealWindow != FocusWindow)) then
		SayWindowTypeAndText (RealWindow)
	endif
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
	SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
	SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction